string GetDescription()
{
	return "Renders the melody into a track adding harmony below the notes";
}

double GetNoteLength(RenderPart @p, int i)
{
	Time t1 = p.GetEventStart(i);
	Time t2 = p.GetEventEnd(i);
	return (t2.m_Bar - t1.m_Bar)*p.GetUniquePart().GetMetrum() + (t2.m_Pos - t1.m_Pos);
}

int abs(int v)
{
	if (v < 0) return -v;
	return v;	
}

double fabs(double v)
{
	if (v < 0) return -v;
	return v;	
}

void Render(RenderPart @p)
{
	for (int i = 0; i < p.GetEvents(); i++)
	{
		int note_pitch = p.GetEventPitch(i);
		
		int poz = p.GetEventStart(i).m_Pos;
		bool strong = true;
		
		if (fabs(poz - p.GetEventStart(i).m_Pos) > 0.1) strong = false;
		
		if (GetNoteLength(p, i) > 0.26)
		{
			Time t = p.GetEventEnd(i);
			t.m_Pos -= 0.1;
			int harm = p.GetHarmonic(t);
			
			
			for (int h = 0; h < p.GetHarmonicComponents(harm); h++)
			{
				int off = 0;
				int harm_pitch = p.GetHarmonicEventPitch(harm, h);
				
				while (harm_pitch + 12 < note_pitch)
				{
					off++;
					harm_pitch+=12;	
				}
				
				while (harm_pitch > note_pitch)
				{
					off--;
					harm_pitch-=12;	
				}
				
				int safe_dist = 2;
				
				if (note_pitch != p.AlignPitch(note_pitch,0)) safe_dist = 3;
				
				if ( abs(harm_pitch - note_pitch) > safe_dist ) 
				{
					if (strong) p.AddNote(p.GetEventStart(i), p.GetEventEnd(i), harm_pitch ,RndInt(85,110));		
					else p.AddNote(p.GetEventStart(i), p.GetEventEnd(i), harm_pitch ,RndInt(75,100));		
				}
			}
		}
		
		if (strong)	p.AddNote(p.GetEventStart(i), p.GetEventEnd(i), note_pitch ,RndInt(118,127));	
		else p.AddNote(p.GetEventStart(i), p.GetEventEnd(i), note_pitch ,RndInt(110,122));	
		
		
	}
}